clear 
name='albedo_new.inp';
data.lstart=0.5;
data.lend=0.7;
data.zen=0;
data.alb=0.1;
data.emiss=1;
data.DU=300;
data.AOT=0;
data.SSA=0.95;
data.g=0.7;
aerstream(data.SSA,data.g);
data.PW=2.0;
data.ctau=0.0;  % cloud tau at 0.6 um
data.dz=1;      % geometrical depth of cloud [km]
data.ztop=11;   % TOP of cloud
ppmv1=0.0;
ppmv2=0.0;   %3.35
if data.ctau>0
 cloud('A',data.ctau,data.dz);
end

[data.z,data.p,data.t,data.q,data.o3]=readAtm(ppmv1,ppmv2);  %read the radiosonde data heigh, pres, temp, RH
readinp(data);
!./streamer albedo_new.inp
data0=readout('albedo_1.des');

fid=fopen('RES.txt','a');
n=length(data0.Fdir);
m=20;    %level 179 hPa


X(3,:)=[data0.Fdir(n),data0.Fdif(n),data0.Ftot(n),data0.Fup_sol(n),data0.Fdn_ter(n),data0.Fup_ter(n),data0.Heating(n)];
X(2,:)=[data0.Fdir(m),data0.Fdif(m),data0.Ftot(m),data0.Fup_sol(m),data0.Fdn_ter(m),data0.Fup_ter(m),data0.Heating(m)];
X(1,:)=[data0.Fdir(1),data0.Fdif(1),data0.Ftot(1),data0.Fup_sol(1),data0.Fdn_ter(1),data0.Fup_ter(1),data0.Heating(1)];


data.ctau=0.0;  % cloud tau at 0.6 um
data.ztop=11;
data.dz=1;      % geometrical depth of cloud [km]
data.PW=2.0;
data.DU=290;
if data.ctau>0
 cloud('A',data.ctau,data.dz);
end
ppmv1=0.0;
ppmv2=0.0;    % 3.35
[data.z,data.p,data.t,data.q,data.o3]=readAtm(ppmv1,ppmv2);  %read the radiosonde data heigh, pres, temp, RH
readinp(data);
!./streamer albedo_new.inp
data1=readout('albedo_1.des');

X(6,:)=[data1.Fdir(n),data1.Fdif(n),data1.Ftot(n),data1.Fup_sol(n),data1.Fdn_ter(n),data1.Fup_ter(n),data1.Heating(n)];
X(5,:)=[data1.Fdir(m),data1.Fdif(m),data1.Ftot(m),data1.Fup_sol(m),data1.Fdn_ter(m),data1.Fup_ter(m),data1.Heating(m)];
X(4,:)=[data1.Fdir(1),data1.Fdif(1),data1.Ftot(1),data1.Fup_sol(1),data1.Fdn_ter(1),data1.Fup_ter(1),data1.Heating(1)];

For_sol=(data1.Ftot-data1.Fup_sol)-(data0.Ftot-data0.Fup_sol);
For_ter=(data1.Fdn_ter-data1.Fup_ter)-(data0.Fdn_ter-data0.Fup_ter);

Y(4,:)=[For_sol(n),For_ter(n)];
Y(5,:)=[For_sol(m),For_ter(m)];
Y(6,:)=[For_sol(1),For_ter(1)];

fprintf(fid,'%s\n','DIR,DIF,TOT_SOL,UP_SOL,DOWN_term,UP_term,H_rate,FOR_SOL,FOR_term')
for i=1:6
 fprintf(fid,'%6.1f %6.1f %6.1f %6.1f %6.1f %6.1f %6.1f %6.1f',X(i,:));
  if i>=4
    fprintf(fid,'%6.1f %6.1f',Y(i,:));
  end
 fprintf(fid,'\n');
end
fprintf(fid,'\n');
fclose(fid);

disp('RESULTS')
disp('CASE 1')

disp(sprintf('%7.2f %7.2f',[data0.Fdn_ter(1),data0.Fup_ter(1)]))
disp(sprintf('%7.2f %7.2f',[data0.Fdn_ter(m),data0.Fup_ter(m)]))
disp(sprintf('%7.2f %7.2f',[data0.Fdn_ter(n),data0.Fup_ter(n)]))

disp(sprintf('%7.2f %7.2f',[data0.Ftot(1),data0.Fup_sol(1)]))
disp(sprintf('%7.2f %7.2f',[data0.Ftot(m),data0.Fup_sol(m)]))
disp(sprintf('%7.2f %7.2f',[data0.Ftot(n),data0.Fup_sol(n)]))

disp('CASE 2')
disp(sprintf('%7.2f %7.2f',[data1.Fdn_ter(1),data1.Fup_ter(1)]))
disp(sprintf('%7.2f %7.2f',[data1.Fdn_ter(m),data1.Fup_ter(m)]))
disp(sprintf('%7.2f %7.2f',[data1.Fdn_ter(n),data1.Fup_ter(n)]))

disp(sprintf('%7.2f %7.2f',[data1.Ftot(1),data1.Fup_sol(1)]))
disp(sprintf('%7.2f %7.2f',[data1.Ftot(m),data1.Fup_sol(m)]))
disp(sprintf('%7.2f %7.2f',[data1.Ftot(n),data1.Fup_sol(n)]))

disp('NET')
disp(sprintf('%7.2f %7.2f',[data1.Fdn_ter(1)-data0.Fdn_ter(1),data1.Fup_ter(1)-data0.Fup_ter(1)]))
disp(sprintf('%7.2f %7.2f',[data1.Fdn_ter(m)-data0.Fdn_ter(m),data1.Fup_ter(m)-data0.Fup_ter(m)]))
disp(sprintf('%7.2f %7.2f',[data1.Fdn_ter(n)-data0.Fdn_ter(n),data1.Fup_ter(n)-data0.Fup_ter(n)]))

disp(sprintf('%7.2f %7.2f',[data1.Ftot(1)-data0.Ftot(1),data1.Fup_sol(1)-data0.Fup_sol(1)]))
disp(sprintf('%7.2f %7.2f',[data1.Ftot(m)-data0.Ftot(m),data1.Fup_sol(m)-data0.Fup_sol(m)]))
disp(sprintf('%7.2f %7.2f',[data1.Ftot(n)-data0.Ftot(n),data1.Fup_sol(n)-data0.Fup_sol(n)]))

disp('FORCING')
disp(sprintf('%7.2f %7.2f',[data1.Fdn_ter(1)-data0.Fdn_ter(1)-data1.Fup_ter(1)+data0.Fup_ter(1)]))
disp(sprintf('%7.2f %7.2f',[data1.Fdn_ter(m)-data0.Fdn_ter(m)-data1.Fup_ter(m)+data0.Fup_ter(m)]))
disp(sprintf('%7.2f %7.2f',[data1.Fdn_ter(n)-data0.Fdn_ter(n)-data1.Fup_ter(n)+data0.Fup_ter(n)]))

disp(sprintf('%7.2f %7.2f',[data1.Ftot(1)-data0.Ftot(1)-data1.Fup_sol(1)+data0.Fup_sol(1)]))
disp(sprintf('%7.2f %7.2f',[data1.Ftot(m)-data0.Ftot(m)-data1.Fup_sol(m)+data0.Fup_sol(m)]))
disp(sprintf('%7.2f %7.2f',[data1.Ftot(n)-data0.Ftot(n)-data1.Fup_sol(n)+data0.Fup_sol(n)]))




return
