function [z,p,t,q,o3]=readAtm(ppmv1,ppmv2)

load atmdata.dat
atmdata=flipud(atmdata);
z=atmdata(:,1);
p=atmdata(:,2);
t=atmdata(:,3);
q=atmdata(:,4);          %absolute humidity in [g/m^3]
o3=atmdata(:,5);


eps=0.622;

x1=ppmv1*eps/1e6;     % mass mixing ration in [g/g]
x2=ppmv2*eps/1e6;
q1=x1/(1+x1)*1e3;         % specific humidity in [g/kg]
q2=x2/(1+x2)*1e3;
R=287;
ro=100*p./(R.*t);
if q1>0
 a=find((p>=0.95)&(p<153));
 b=find((p>=153)&(p<=179));
 q(a)=q1*ro(a);      % absolute humidity [g/m^3]
 q(b)=q2*ro(b);
end
			 

return
load atm_midsum.dat
x=atm_midsum;
[n,m]=size(x); 
z=[];
p=[];
t=[];
q=[];
o3=[];
for i=1:5
    z=[z,x(i,:)];
    p=[p,x(i+5,:)];
    t=[t,x(i+10,:)];
    q=[q,x(i+15,:)];
    o3=[o3,x(i+20,:)];
end
