function [wav,ext0,omega,g]=cloud(type,ctau,dz)

if type=='A'
 wav=[0.3:0.05:1,1.5:0.5:4,5:1:10,15:5:100,150:10:500];
% wav=[4,5:1:10,15:5:100,150:50:500];
 ext0=1*ones(size(wav));
 g=0.8*ones(size(wav));
 omega=1.0*ones(size(wav));
 ind=find(wav>=4);
 omega(ind)=0.6;
 else
 load clouds1.txt
 load clouds2.txt
 clouds1(:,2:3)=1000*clouds1(:,2:3);
 X=[clouds1;clouds2];
 wav=X(:,1);
end 
if type=='Ci'
  C=0.58;  % concetration
  ext0=C*X(:,2);
  omega=X(:,6);
  g=X(:,4);
 elseif type=='Co'
  C=1.0;
  ext0=C*X(:,3);
  omega=X(:,7);
  g=X(:,5);
end

% Normalization of extinction to TAU for 0.6 um
ind=find(wav==0.60);
if isempty(ind)==1
 [a,ind]=min(abs(wav-0.60));
end
ext0=ext0*ctau/(dz*ext0(ind));
fid=fopen('cloud.dat','w');
fprintf(fid,'%s\n','1-line: num of wav and num of Lagrange coeff, zero for assymetry parameter');
fprintf(fid,'%d %d\n',[length(ext0),0]);
fprintf(fid,'%s\n','2-line wav ext ssa g');
for i=1:length(ext0);
 fprintf(fid,'%6.3f %6.3f %6.3f %6.3f\n',[wav(i),ext0(i),omega(i),g(i)]);
end 
