function n=ref_water(lambda)
% The complex refractive index of water / by David J. Segelstein.  1981.
% ix, 167 leaves : ill. ; 29 cm.
% Thesis (M.S.)--Department of Physics. University of
% Missouri-Kansas City, 1981.
% input:
%      lambda in [um]
% output:
%      n - complex refractive index
load refwater.dat
m=interp1(refwater(:,1),refwater(:,2),lambda);
k=interp1(refwater(:,1),refwater(:,3),lambda);
if ((min(lambda)<min(refwater(:,1)))|(max(lambda)>max(refwater(:,1))))
    disp ('No water refractive index for this  wavelength')
end
n=m+i*k;

