function n=ref_soot(lambda)
% refrative index for soot from Chang, H. and T. T. Charalampopoulos (1990). 
% input: 
%       lambda - wavelength in [um]
% output:
%        n complex refractive index

k=0.5821+0.1213*log(lambda)+0.2309*(log(lambda)).^2-0.01*(log(lambda)).^3;
m=1.811+0.1263*log(lambda)+0.027*(log(lambda)).^2+0.0417*(log(lambda)).^3;

n=m+i*k;