function n=ref_insoluble(lambda)
% The complex refractive index of water insoluble aerosols
% based on OPAC/GADA data base
% The water insoluble include: mostly soil particles with a certain amount 
% of organic materal
% input:
%      lambda in [um]
% output:
%      n - complex refractive index
load refinsoluble.dat
m=interp1(refinsoluble(:,1),refinsoluble(:,2),lambda);
k=interp1(refinsoluble(:,1),refinsoluble(:,3),lambda);
if ((min(lambda)<min(refinsoluble(:,1)))|(max(lambda)>max(refinsoluble(:,1))))
    disp ('No insoluble refractive index for this  wavelength')
end
n=m+i*k;