function [param,num,RH]=read_sizedistr
% read input data file including parameters of aerosol size distributions
% output:
%       param - parameters of size distribution
%       num - aerosol number
%       RH - relative humidity

fid=fopen('sizedistr.dat');
s=1;
while s>0
 s=fgets(fid);
 k=1;
 if s(1)~='%'
     break
 end    
end

a=findstr(s,':');
RH=str2num(s((a+1):length(s)));
s=fgets(fid);
a=findstr(s,':');
ayes=findstr(s(a:length(s)),'yes');
ano=findstr(s(a:length(s)),'no');
if isempty(ayes)==0
   s=1;
   while s>0
    s=fgets(fid);
    k=1;
    if s(1)~='%'
      break
    end    
   end
   for i=1:10
       a=findstr(s,':');
       dataN=str2num(s(a+1:length(s)));
       if isempty(dataN)==0
           n0(i)=dataN;
       else
           n0(i)=0;
       end    
       s=fgets(fid);
   end  
  num=find(n0>0);
  N0=n0(num);
  param(:,1)=N0';
  load Gadsparam
  for i=1:length(N0)
   param(i,2)=spline(gads.RH,gads.R_wet(num(i),:),RH);
   param(i,3)=spline(gads.RH,gads.Sig(num(i),:),RH);
   param(i,4)=spline(gads.RH,gads.Rmin(num(i),:),RH);
   param(i,5)=spline(gads.RH,gads.Rmax(num(i),:),RH);
  end 
elseif isempty(ano)==0
   s=1;
   while s>0
    s=fgets(fid);
    k=1;
    if s(1)~='%'
      break
    end    
   end 
   for i=1:10-1
       s=fgets(fid);
   end    
   while s>0
    s=fgets(fid);
    k=1;
    if s(1)~='%'
      break
    end    
   end  
   for i=1:6
   a=findstr(s,':');
   x=str2num(s(a+1:length(s)));
   if ((mod(length(x),5)==0)&(isempty(x)==0))    
     nmod=length(x)/5;
     y=reshape(x, 5,nmod)';
     param(k:k+nmod-1,:)=y;    
     if i<=4
         num(k:k+nmod-1)=i;
      elseif i==5
         num(k:k+nmod-1)=6;
      elseif i==6
         num(k:k+nmod-1)=10;
     end
     k=k+nmod;
   end 
   s=fgets(fid);
end     
else
    ('Bad ipput data file')
    return
end    
fclose(fid);

