function n_mix=mixture(n,f)
% Internal Mixture refractive index for unlimited numbar of aerosols
% n - refractive index where: columns coresponde to wavelength
%     and rows to aerosol model
% f - volume aerosol type fraction 
[nmod,nlambda]=size(n);
n_new=n(1,:);
for i=1:nmod-1
   frac=f(i+1)/sum(f(1:i+1)); 
   n_new=maxwell_garnet(n_new,n(i+1,:),frac);     
end    
n_mix=n_new;