 function mix_calc(data_type,mix_type,lambda)
 % Calculate aerosol size distributions from input data and
 % run procedures for internal or external mixtures 
 % input:
 %    data_type: input data: 2 for mass density, 3 for size distribution
 %    mix_type: type of mixture, 'e' for external, 'i' for internal
 %    lambda: wawelength in micrometers
 
 if data_type==2
    [param,num,RH]=conversion;
 elseif data_type==3
    [param,num,RH]=read_sizedistr;
 end
 npoint=250;
 for k=1:length(num)
     n(k,:)=ref_index_RH(num(k),RH,lambda);
     r(k,:)=logspace(log10(param(k,4)),log10(param(k,5)),npoint);      
     N(k,:)=param(k,1)*lognormal(r(k,:),param(k,2),param(k,3));
 end
 if mix_type=='e'                      % external
     ext_mix(n,lambda,N,r);
  elseif mix_type=='i'
     Rmin=min(param(:,4));
     Rmax=max(param(:,5));
     R=logspace(log10(Rmin),log10(Rmax),npoint);
     for i=1:length(num)
        Ns(i,:)=interp1(r(i,:),N(i,:),R);    
        V(i)=4/3*trapz(r(i,:),N(i,:).*(r(i,:)).^3);
     end    
     a=isnan(Ns);
     Ns(a)=0;     
     N_int=sum(Ns);
     r_int=R;
     v_frac=V./sum(V);
     n_int=mixture(n,v_frac);
     int_mix(n_int,lambda,N_int,r_int);
 end    