function [ext,omega,G]=mie_size(n,lambda,N,r)
% mie calculation of optical properties for spherical particles
% with size distribution given by N
% input:
%    n - refractive indexes as a function of wavelength
%    lambda - wavelength in [um] (micrometer)
%    N - size distribution of r
%    r - raddius in [um]
% output:
%    ext - extinction coefficients in [1/km]
%    omega - single scattering coefficient
%    G - asymmetry parameter as a function of wavelength
  
for j=1:length(lambda)
  for i=1:length(r);
    X(i)=2*pi*r(i)/lambda(j); 
    [s1,s2,Qext(i),Qscat(i),Qback(i),g(i)]=mie(X(i),n(j),5);
  end 
 Qabs=Qext-Qscat; 
 Fscat=pi*r.^2.*N.*Qscat;
 Fext=pi*r.^2.*N.*Qext;
 Fabs=pi*r.^2.*N.*Qabs;
 ext(j)=trapz(r,Fext)*1e-3;   % unit [1/km]
 abs(j)=trapz(r,Fabs)*1e-3; 
 G(j)=trapz(r,Fscat.*g)/trapz(r,Fscat);
end
omega=1-abs./ext;
 
	      