function n3=maxwell_garnet(n1,n2,f)
% Maxwell-Garnet relation to find the refraction index
% of a mixture of 2 substances
% input:
%       n1- refraction index of the 1-st substance
%       n2 ------//--------         2-nd  ---//---
%       t - volume fraction of substance 2
% output:
%       n3 - refraction index of mixture (internal mixture)
if f>0.5
    f=1-f;
    nn1=n1;
    nn2=n2;
    n1=nn2;
    n2=nn1;
end    
e1=n1.^2;
e2=n2.^2;
term=(e2-e1)./(e2+2.*e1);
e3=e1.*(1+(3*f.*term)./(1-f.*term));
n3=sqrt(e3);