function res=ext_mix(n,lambda,N,r)
% Calculate aerosol optical properties for external mixture and
% write results to file: ext_mix.out
% input:
%    n- refractive indexes
%    lambda - wavelengths in micrometers
%    N - aerosol size distribution
%    r - aerosol radiuses coresponds to size distributions

[nmode,nlambda]=size(n);
for k=1:nmode
   [ext(k,:),omega(k,:),g(k,:)]=mie_size(n(k,:),lambda,N(k,:),r(k,:));  % MIE calculations
end    
% optical parameters of external mixture
extnew=sum(ext);
omeganew=sum((ext.*omega))./extnew;
gnew=sum((ext.*omega.*g))./sum(ext.*omega);

% Write data to file
fid=fopen('ext_mix.out','w');
for k=1:length(lambda)
   fprintf(fid,'%6.3f  %8.6f  %5.4f  %5.4f\n',[lambda(k),extnew(k),omeganew(k),gnew(k)]);
end
fclose(fid);