function [Qext,Qscat]=coated(num_core,num_coated,Xcore,Xcoated,lambda);
% Caclulate extinction and scattering coefficient for coated particles
% input:
%     num_core- core aerosol number (see main program)
%     num_coated- coated aerosol number (see main program)
%     Xcore- size parameter for core particle
%     Xcoated - size parameter for coated particle
%     lambda - waavelengths in micrometers
% output:
%     Qext - extinction efficiency
%     Qscat - scattering efficiency

n_core=ref_aerosols(num_core,lambda)
n_coated=ref_aerosols(num_coated,lambda)
for i=1:length(lambda)
 [Qext(i),Qscat(i)]=coat(Xcore(i),Xcoated(i),n_core(i),n_coated(i));
 % extinction and scattering efficiency
end



