function Rwc=windalb(pws,pwl)
% effective reflectance of the whitecaps (Koepke, 1984)
% INPUT:  pws=speed of wind (in m/s)
%         pwl=wavelength of the computation (in micrometer)
% OUTPUT: Rwc reflectance of the whitecaps 

if pwl>3.9
   Rwc=0;
   return
end   
ref=[0.220,0.220,0.220,0.220,0.220,0.220,0.215,0.210,0.200,0.190,...
     0.175,0.155,0.130,0.080,0.100,0.105,0.100,0.080,0.045,0.055,...
     0.065,0.060,0.055,0.040,0.000,0.000,0.000,0.000,0.000,0.000,...
     0.000,0.000,0.000,0.000,0.000,0.000,0.000,0.000,0.000];
% conversion of parameter
  wspd=pws;
  wl=pwl;

% COMPUTE WHITECAPS REFLECTANCE (LAMBERTIAN)
   W=2.95e-06*(wspd.^3.52);   % W- fraction of sea coverted white caps
   iwl=1+round((wl-0.2)/0.1);
   wlp=0.5+(iwl-1).*0.1;
   Ref_i=ref(iwl+1)+(wl-wlp)/0.1*(ref(iwl)-ref(iwl+1));
   Rwc=W.*Ref_i;
   
