function flux=seasalt_flux(u,r)
% flux =dF/dr, seasalt production by ocean for particle r>0.1 um
% flux [particles/m^2*s^1]
% r in [um]
% relationship from Gong 1997, Monahan, 1986
% u wind speed at 10m


B=(0.38-log10(r))/0.65;
flux=1.373*u.^3.41.*r.^(-3).*(1+0.057*r.^1.05).*10.^(1.19*exp(-B.^2));