function [Qext,Qscat,Qabs,Qback]=scat_small(x,n,k);
% Scattreing for small particle 
% for x<0.5 this code is consistance with mie
% This equation corespond to Rayleigh scattering
% input : 
%       x - size parameter
%       n - real part of refraction index
%       k - imaginary part of refraction index
% output:
%       Qext - extinction efficiency
%       Qscat - scattering efficiency
%       Qabs - absorption efficiency
%       Qback -backscattter efficiency 
m=n+i*k;
m_fac=(m.^2-1)./(m.^2+2);
Qscat=8/3*x.^4*(abs(m_fac)).^2;
Qback=4*x.^4*(abs(m_fac)).^2;

Qext=4.*x.*imag((m_fac).*(1+x.^2/15.*m_fac.*(m.^4+27*m.^2+38)/(2*m.^2+3)))+...
   8/3*x.^4*real((m_fac).^2);
Qabs=Qext-Qscat;