function n=ref_sulfate(lambda)
% The complex refractive index of sulfate based on HITRAN200, OPAC/GADA data base
% the sulfate include 75% of H2SO4 at 215K therefor descripes stratopsheric sulfates
% input:
%      lambda in [um]
%   parameter temperature : T  
% output:
%      n - complex refractive index
T=290;
load refsulfate.dat
% T=215 K
 m1=interp1(refsulfate(:,1),refsulfate(:,2),lambda);
 k1=interp1(refsulfate(:,1),refsulfate(:,3),lambda);
% T=300 K 
 m2=interp1(refsulfate(:,1),refsulfate(:,4),lambda);
 k2=interp1(refsulfate(:,1),refsulfate(:,5),lambda);  
if T<=215
    n=n1;
    k=k1;
 elseif T>=300   
    n=n2;
    k=k2;
 else
    m=m1+(m2-m1)/(300-215)*(T-215);
    k=k1+(k2-k1)/(300-215)*(T-215);
end 
 n=m+i*k;
