function n=ref_soluble(lambda)
% The complex refractive index of water soluble aerosols
% based on OPAC/GADA data base
% The water soluble include: sulfates, nitrates, organic, and 
% water soluble substances. The sulfate aeerosol in about half
% of water soluble component.
% input:
%      lambda in [um]
% output:
%      n - complex refractive index
load refsoluble.dat
m=interp1(refsoluble(:,1),refsoluble(:,2),lambda);
k=interp1(refsoluble(:,1),refsoluble(:,3),lambda);
n=m+i*k;