function n=ref_seasalt(lambda)
% The complex refractive index of water / by Shettle-Hitran		
% A-7.  Volz, F. E. (1972) Infrared refractive index of atmospheric			
% aerosol substance, Appl. Opt., 11:755-759.			
% A-8.  Shettle, E. P. and Fenn, R. W. (1979)  Models for the			
% Aerosols of the Lower Atmosphere and the Effects of Humidity			
% Variations on Their Optical Properties, AFGL-TR-79-0214, 20 Sept			
% 1979, ADA085951.			
% A-9.  Volz, F. E. (1972) Infrared absorption by atmospheric			
% aerosol substance, J. Geophys. Res., 77:1017-1031.			
% A-5.  Eldridge, J. E. and Palik, E. D. (1985) Sodium Chloride, in			
% Handbook of Optical Constants of Solids, Edited by E. D. Palik,			
% the same data base is used in OPAC/GADS program
% input:
%      lambda in [um]
% output:
%      n - complex refractive index
load refseasalt.dat
% First 2 column is refractive index for Sodium Chloride 
m=interp1(refseasalt(:,1),refseasalt(:,4),lambda);
k=interp1(refseasalt(:,1),refseasalt(:,5),lambda);
n=m+i*k;
