function res=rayleigh(lambda,p);
% Rayleigh optical tickness based on Deschamps et al, 1983
% input:
%      lambda - wavelenght in nm
%      p - pressure in hpa
% output:
%      res- molecular optical thickness
 
A=8436.e-6;
B=-1225.e-7;
C=14.e-5;
p0=1013;
lambda=lambda*1.e-3;
res=p/p0*(A*lambda.^(-4)+B*lambda.^(-5)+C*lambda.^(-6));