function res=planck(T,lambda)
% Computes the blackbody flux according to Planck's function
%     notice: radiance=Flux/pi
%     for solar constant result should be multiply by r=6.96*1.e8/(149.6*1.e9);
% input:
%       T   = temperature in K
%       lambda = wavelength in um 
% output:
%       res = Flux in Watts/(m^2 um^-1)
k=1.3806*1.e-23;
c=3.e8;
h0=6.6262*1.e-34;
x=lambda*1.e-6;
res0=2*pi*c^2*h0.*x.^-5./(exp(h0*c./(k*T.*x))-1);
res=res0*1e-6;

