function res=opt_ozon(lambda,DU)
% ozone optical thickness
% requires ozon.dat file
% input: 
%       lambda - wavelength in nm
%       DU - total ozon  in Dobson  unit
% output:
%        res - ozone opticak thicknes  
x=lambda/1000;
DUnew=DU/1000;
load ozon.dat
a_ozon=interp1(ozon(:,1),ozon(:,2),x);  % calculate absorbion coeff [1/cm]
res=a_ozon*DUnew;
a=isnan(res);
res(a)=0;