function [sig,beta]=molec(lambda,T,p);
% Calculate the extinction coefficien and 
% backscatter based on temperature and pressure

% input:
%      lambda - wavelength in nm
%      T - temperature in K
%      p -  pressure in hpa
% output:
%       sig - molecular extinction coefficient
%       beta - molecular backscatter coefficient

R=287;
g=9.81;
P=3/(8*pi);
sig=g/(R*T)*rayleigh(lambda,p);
beta=sig*P;