function mi=mi_oz(el,alt,lat)
% Ozon optical path
% input:
%       el - sun elevation angle in deg
%       alt - altitude in km
%       lat - latitude in deg
% output:
%       mi - ozone path (when sun is in zenith mi=1) 
zn=(90-el)*pi/180;   % aun zenith angle
R=6371;              % Earth radius
h=26-0.1*lat;        % average of battom ozonosphere
mi=(R+h)./((R+h).^2-(R+alt).^2.*sin(zn).^2).^0.5;      %ozon optical depth