function R1=fresn(nr,ni,coschi,sinchi);
% to compute the Fresnel's coefficient of reflection (see for
% example M. Born and E. Wolf, Principles of Optics, Pergamon Press, fifth
% edition, 1975, pp 628
% input parameters: nr=index of refraction of the sea water
%                   ni=extinction coefficient of the sea water
%                   coschi & sinchi=cosine and sine of the incident radiation 
%                                   with respect of the wave facet normal.
% output parameter: R1=Fresnel's coefficient for reflection

% absolute value for a1 to get v=0 when ni=0

  a1=abs(nr*nr-ni*ni-sinchi*sinchi);
  a2=sqrt((nr*nr-ni*ni-sinchi*sinchi)^2.+4*nr*nr*ni*ni);
  u=sqrt(0.5*(a1+a2));
  v=sqrt(0.5*(-a1+a2));
  Rr2=((coschi-u)^2+v*v)/((coschi+u)^2+v*v);
  b1=(nr*nr-ni*ni)*coschi;
  b2=2*nr*ni*coschi;
  Rl2=((b1-u)^2+(b2+v)^2)/((b1+u)^2+(b2-v)^2);
  R1=(Rr2+Rl2)/2;  
 