function [Qext,Qscat,Qabs]=ADT(x,n,k)
% ADT Anomalous diffraction theory
% input: 
%       x - size parameter
%       n - real part of refraction index
%       k - imaginary part of refration index
% output:
% Qext - extinction efficiency
% Qscat - scattering efficiency
% Qabs - absorption efficiency

v=x*k;
u=x*(n-1);
w=v+i*u;
w=2*w;
K=0.5+exp(-w)./w+(exp(-w)-1)./w.^2;
Qext=4*real(K);
w=4*v;
if k==0
   Qabs=0;
else
  K=0.5+exp(-w)./w+(exp(-w)-1)./w.^2;
  Qabs=2*K;
end
Qscat=Qext-Qabs; 