function n_wet=ref_index_RH(num,RH,lambda);
% calculates refrative index of aerosol particles at 
% relative humidity RH and wavelength lambda [um]
% input: 
% num - aerosol number 1-insoluble, 2-soluble, 3-soot,
%       4-sea salt accumulation, 5 sea salt coarse
%       6-dust nucleaction, 7-dust accumulation
%       8-dust coarse, 9-dust transported, 10-sulfate
% RH  - Relative Humidity
% lambda - wavelength in [nm]
% output:
% n_wet - complex refractive index aerosol particles at RH

load Gadsparam   % load GADS particles Growth Factor
n_water=ref_water(lambda);

for j=1:length(num)
    GF=spline(gads.RH,gads.GF(num(j),:),RH);
    fract=1./GF.^3;   % volume fraction of dry aerosol relative to wet particle
    n_dry=ref_aerosols(num(j),lambda);
    %m_wet=real(n_water)+fract.*(real(n_dry)-real(n_water));
    %k_wet=imag(n_water)+fract.*(imag(n_dry)-imag(n_water));
    m_wet=real(n_dry).*fract+real(n_water)*(1-fract);
    k_wet=imag(n_dry).*fract+imag(n_water)*(1-fract);
    n_wet(j,:)=m_wet+k_wet*i;
end    