function n_wet=ref_index_RH(num,RH,lambda);
% calculates refrative index of aerosol particles at 
% relative humidity RH and wavelength lambda [um]
% input: 
% num - aerosol number 1-insoluble, 2-soluble, 3-soot,
%       4-sea salt accumulation, 5 sea salt coarse
%       6-dust nucleaction, 7-dust accumulation
%       8-dust coarse, 9-dust transported, 10-sulfate
% RH  - Relative Humidity
% lambda - wavelength in [nm]
% output:
% n_wet - complex refractive index aerosol particles at RH

load Gadsparam   % load GADS particles Growth Factor

n_water=ref_water(lambda);
for j=1:length(num)
    GF=spline(gads.RH,gads.GF(num(j),:),RH);
    fract=1./GF.^3;   % volume fraction of dry aerosol relative to wet particle
    n_dry=ref_aerosols(num(j),lambda);
    n_wet(j,:)=maxwell_garnet(n_water,n_dry,fract);
end    