function [param,gads_param]=read_mass
% Read input data file "aeromass.dat"
% output:
%       param - structure variable of aeosol size distribution parameters 
%       gads_param - OPAC/GADS aerosol size distribution 
       
fid=fopen('aeromass.dat');
s=1;
while s>0
 s=fgets(fid);
 if s(1)~='%'
     break
 end    
end
a=findstr(s,':');
Rsub=str2num(s(a+1:length(s)));
s=fgets(fid);
a=findstr(s,':');
Rsup=str2num(s(a+1:length(s)));
s=fgets(fid);
a=findstr(s,':');
RHdiv=str2num(s(a+1:length(s)));

s=fgets(fid);
a=findstr(s,':');
RH=str2num(s(a+1:length(s)));

for i=1:6
  for j=1:2  
    s=fgets(fid);
    a=findstr(s,':');
    x=str2num(s(a+1:length(s)));
    if isempty(x)==1
       x=0;
    end
   data(i,j)=x;
 end 
end    
while s>0
 s=fgets(fid);
 if s(1)~='%'
     break
 end    
end
for i=1:6
    a=findstr(s,':');
    nmod=str2num(s(a+1:length(s)));
    if nmod>2
        disp('Bad number of size distributions')
        return
    end 
    if isempty(nmod)==1
        nmod=0;
    end    
    data(i,3)=nmod;
    s=fgets(fid);
end
while s>0
 s=fgets(fid);
 if s(1)~='%'
     break
 end    
end
for i=1:10
    a=findstr(s,':');
    gdata(i,:)=str2num(s(a+1:length(s)));
    s=fgets(fid);
end   
gads_param.Rmode=gdata(:,1);
gads_param.Sig=gdata(:,2);
gads_param.Rmin=gdata(:,3);
gads_param.Rmax=gdata(:,4);

fclose(fid);

aero_mod=[1,2,3,4,6,10];
a=find(data(:,3)>0);
param.msub=data(a,1);
param.msup=data(a,2);
param.nmod=data(a,3);
param.aero_mod=aero_mod(a);
param.Rsub=Rsub;
param.Rsup=Rsup;
param.RHdiv=RHdiv;
param.RH=RH;



