clear
disp('***************************************************************')
disp('                AEROSOL OPTICAL DATABASE ver. 1.0')
disp('               by Krzysztof M. Markowicz, May 2003')
disp('                    Dissertation Appendix C')
disp('            Build in Matlab ver. 6.1 for Win and Linux')
disp('***************************************************************')
disp(' ')
disp('0 - help')
disp('1 - aerosol refractive index database')
disp('2 - aerosol optical properties based on particle mass density')
disp('3 - aerosol optical properties based on particle number density')
disp('4 - aerosol optical properties for coated spheres')

k=input('Choose one : ');

if k==0
    disp('------------------------------------------------------------')
    disp('This code make posible calculate aerosol properties such as:')
    disp('extinction coefficient') 
    disp('single scattering albedo') 
    disp('asymmetry parameters')
    disp('as a function of wavelengths, aerosol type and mixture type')
    disp('This database includes 6 aerosol types:')
    disp('insoluble')
    disp('soluble')
    disp('soot')
    disp('sea salt')
    disp('dust')
    disp('sulfate')
    disp('Optical properties are calculated based on MIE code (Bohren and Huffman, 1987)')
    disp('for two types of aerosol mixture: internal and external')
    disp('In addition optical properties can be calculated for coated spheres (Bohren and Huffman, 1987)')
    disp('Calculations can be performed for two inputs:')
    disp('for aerosol mass density of each aerosol category or')
    disp('for aerosol number density of each aerosol category') 
end    
if k==1 
  disp('-------------------------------------------------------------')
  disp('                  Aerosol Refractive Index')
  disp('Aerosols Type')  
  disp('1       - insoluble')
  disp('2       - soluble')
  disp('3       - soot')
  disp('4,5     - sea salt')
  disp('6,7,8,9 - dust')
  disp('10      - sulfate')
  aero_num=input('Select aerosols type : ');
  RH=input('Relative humidity :');
  if RH>99
      disp('Error, RH should be less or equal 99%')
      return
  end    
  lambda=input('Wavelength in [um] :');
  n_ref=ref_index_RH(aero_num,RH,lambda);  
  disp('*************************************************************')
  disp('Wavelength, aerosol refractive index')
  for i=1:length(lambda)
     disp([lambda(i),n_ref(i)])
  end   
end

if ((k==2)|(k==3))
  disp('---------------------------------------------------------------------')
  disp('Aerosol optical properties are available for following aerosols types')
  disp('')  
  disp('1       - insoluble')
  disp('2       - soluble')
  disp('3       - soot')
  disp('4,5     - sea salt')
  disp('6,7,8,9 - dust')
  disp('10      - sulfate')
  disp('---------------------------------------------------------------------')
  disp('')
end
if k==2
    disp('Edit and modify input file: "aeromass.dat" and press enter');
    pause
    mix=input('External (e) or internal (i) type of mixture : ','s');
    lambda=input('Wavelenght in micromiters, in bracket [] if more than one :');
    disp('*********************************************************************')
    if mix=='e'
        mix_calc(k,mix,lambda);    
        disp('Data was written to ext_mix.out file')
    elseif mix=='i'
        mix_calc(k,mix,lambda);
        disp('Data was written to int_mix.out file')
    else
        disp('Error, bad mixture type')
    end    
    
end

if k==3
    disp('Edit and modify input file: "sizedistr.dat" and press enter')
    pause
    mix=input('External (e) or internal (i) type of mixture : ','s');
    lambda=input('Wavelenght in micromiters in bracket [] if more than one : ');
    if mix=='e'
        mix_calc(k,mix,lambda);    
        disp('Data was written to ext_mix.out file')
    elseif mix=='i'
        mix_calc(k,mix,lambda);
        disp('Data was written to int_mix.out file')
    else
        disp('Error, bad mixture type')
    end    
end
 if k==4
  disp('--------------------------------------------------------------------')
  disp('Aerosol optical properties for coated spheres                       ')
  disp('--------------------------------------------------------------------')  
  disp('')  
  disp('1       - insoluble')
  disp('2       - soluble')
  disp('3       - soot')
  disp('4,5     - sea salt')
  disp('6,7,8,9 - dust')
  disp('10      - sulfate')
  num_core=input('Select aerosol type for core : ');
  r_core=input('core radius in micrometers : ');
  num_coated=input('Select coated aerosol : ');
  r_coated=input('radius of coated particles (core plus coated) : ');
  if r_coated<=r_core
      disp('Error, coated radius smaller than core radius')
      return
  end    
  lambda=input('Wavelenght in micromiters in braket [] : ');
  Xcore=2*pi*r_core./lambda;   % size parameter
  Xcoated=2*pi*r_coated./lambda;   % size parameter
  [Qext,Qscat]=coated(num_core,num_coated,Xcore,Xcoated,lambda);
  omega=Qscat./Qext;
  disp('')
  disp('Wavelengths, extinction efficiency, single scattering albedo')
  for i=1:length(lambda)
     disp([lambda(i),Qext(i),omega(i)])    
  end    
 end    

