function res=int_mix(n,lambda,N,r)
% Calculate aerosol optical properties for internal mixture and
% write results to file: int_mix.out
% input:
%    n- refractive indexes
%    lambda - wavelengths in micrometers
%    N - aerosol size distribution
%    r - aerosol radiuses coresponds to size distributions

[ext,omega,g]=mie_size(n,lambda,N,r);    % MIE calculations

% Write data to file
fid=fopen('int_mix.out','w');
fprintf(fid,'Wavelength, refractive_index, extinction, SSA, g'); 
fprintf(fid,'\n');
for k=1:length(lambda)
   fprintf(fid,'%6.3f %4.3f+%4.3fi %4.3f %8.6f  %5.4f  %5.4f',[lambda(k),real(n(k)),imag(n(k)),ext(k),omega(k),g(k)]);
   fprintf(fid,'\n');
end
fclose(fid);