function [RES, num, RH]=conversion
% converion mass density to particle number 
% output: 
%      RES - matrix ,1-st column particle number density, 2-nd mode radius
%            3 geometric standard devation, 4-th Rmin, 5-th Rmax
%      num - aerosols number
%      RH - aerosol relative humidity
[param,gads_param]=read_mass;      % read input file 
a=find(param.nmod==1);             % aerosol type described by single modal size distribution
num1=param.aero_mod(a);           
b=find(param.nmod==2);             % aerosol type described by bi-modal size distribution
num2=param.aero_mod(b);
load Gadsparam                     % read GADS/OPAC database parameters 
for i=1:length(param.aero_mod)
  % Growth factor for RH at which aerosols was divided on sub and supmicron   
  GF(i)=spline(gads.RH,gads.GF(param.aero_mod(i),:),param.RHdiv);
end

% bi-modal only for sea salt and dust particles
if isempty(num2)==1
    aseasalt=[];
  else
 aseasalt=find(num2==4); 
end    
if isempty(aseasalt)==0
  num_seasalt=find(param.aero_mod==4);  
  for k=4:5;   
    R=logspace(log10(gads_param.Rmin(k)),log10(gads_param.Rmax(k)),1000);
    N=lognormal(R,gads_param.Rmode(k),gads_param.Sig(k));
    r1=param.Rsub/GF(num_seasalt);   
    r2=param.Rsup/GF(num_seasalt);
    a=find((R<=r2)&(R>=r1));
    X10(k)=4/3*pi*gads.ro_dry(k)*trapz(R(a),N(a).*R(a).^3);
    a=find(R<r1);
    X1(k)=4/3*pi*gads.ro_dry(k)*trapz(R(a),N(a).*R(a).^3); 
  end
 v=4;
 N0acc(num_seasalt)=(param.msub(num_seasalt)-X1(v+1)/X10(v+1)*param.msup(num_seasalt))/(X1(v)-X10(v)*X1(v+1)/X10(v+1));
 N0coa(num_seasalt)=(param.msup(num_seasalt)-X10(v)*N0acc(num_seasalt))/X10(v+1);
 if ((N0acc(num_seasalt)<0)|(N0coa(num_seasalt)<0))
     disp('Error Negative particles number for Sea Salt, try modify GADS parameters')
     return
 end    
 N00(v)=N0acc(num_seasalt);
 N00(v+1)=N0coa(num_seasalt);
end 

if isempty(num2)==1
    adust=[];
  else
 adust=find(num2==6); 
end    
if isempty(adust)==0
   num_dust=find(param.aero_mod==6); 
   for k=7:8;   
    R=logspace(log10(gads_param.Rmin(k)),log10(gads_param.Rmax(k)),1000);
    N=lognormal(R,gads_param.Rmode(k),gads_param.Sig(k));
    r1=param.Rsub/GF(num_dust);   
    r2=param.Rsup/GF(num_dust);
    a=find((R<=r2)&(R>=r1));
    X10(k)=4/3*pi*gads.ro_dry(k)*trapz(R(a),N(a).*R(a).^3);
    a=find(R<r1);
    X1(k)=4/3*pi*gads.ro_dry(k)*trapz(R(a),N(a).*R(a).^3); 
  end
 v=7;
 N0acc(num_dust)=(param.msub(num_dust)-X1(v+1)/X10(v+1)*param.msup(num_dust))/(X1(v)-X10(v)*X1(v+1)/X10(v+1));
 N0coa(num_dust)=(param.msup(num_dust)-X10(v)*N0acc(num_dust))/X10(v+1);   
  if ((N0acc(num_dust)<0)|(N0coa(num_dust)<0))
     disp('Error Negative particles number for Dust, try modify GADS parameters')
  return
 end
 N00(v)=N0acc(num_dust);
 N00(v+1)=N0coa(num_dust);
end    

% Single size distribution
for p=1:length(num1);
  k=num1(p);
  num_aero=find(param.aero_mod==k);
  r=logspace(log10(gads_param.Rmin(k)),log10(gads_param.Rmax(k)),1000);
  rm=logspace(log10(gads_param.Rmode(k))-1,log10(gads_param.Rmode(k))+1,50);
  for l=1:length(rm)
    N=lognormal(r,rm(l),gads.Sig(k));
    r1=param.Rsub/GF(num_aero);   
    r2=param.Rsup/GF(num_aero);
    a=find((r<=r2)&(r>=r1));
    F10(l)=4/3*pi*gads.ro_dry(k)*trapz(r(a),N(a).*r(a).^3);
    a=find(r<r1);
    F1(l)=4/3*pi*gads.ro_dry(k)*trapz(r(a),N(a).*r(a).^3); 
  end
  M_ratio=F10./F1;
  RM10(k)=interp1(M_ratio,rm,param.msup(num_aero)/param.msub(num_aero));
  F10new=interp1(M_ratio,F10,param.msup(num_aero)/param.msub(num_aero));
  N10(k)=param.msup(num_aero)/F10new;
end
a=isnan(RM10);
b=find(a==1);
if isempty(b)==0
    disp('Error NaN value of particle number, try modify GADS parameters');
    return
end 
if isempty(num2==1)
    N00=[];
  else   
    a=find(N00>0);
end 
N10(a)=N00(a);
clear N00 N0
N0=N10;
RM=RM10;
RM(a)=gads_param.Rmode(a);
for i=1:10
  GFaero(i)=spline(gads.RH,gads.GF(i,:),param.RH);
  Rmin(i)=spline(gads.RH,gads.Rmin(i,:),param.RH);
  Rmax(i)=spline(gads.RH,gads.Rmax(i,:),param.RH);
end
a=find(RM>0);
rm=RM(a).*GFaero(a);
RES(:,1)=N0(a)';
RES(:,2)=rm';
RES(:,3)=gads_param.Sig(a);
RES(:,4)=Rmin(a)';
RES(:,5)=Rmax(a)';
num=a;
RH=param.RH;

disp('Particles number and mode radius')
name{1}='insoluble            ';
name{2}='soluble              ';
name{3}='soot                 ';
name{4}='sea salt accumulation';
name{5}='sea salt coarse      ';
name{6}='dust nucleation      ';
name{7}='dust accumulation    ';
name{8}='dust coarse          ';
name{9}='dust transported     ';
name{10}='sulfate              ';

for i=1:length(num)
   disp([name{num(i)},' :  ',num2str(RES(i,1)),'     ',num2str(RES(i,2))])
end    